/*
 * Decompiled with CFR 0.152.
 */
package com.scsoft.scpt.sso.config;

import com.scsoft.scpt.sso.filter.OauthSsoFilter;
import com.scsoft.scpt.sso.properties.AuthSsoProperties;
import java.util.Collection;
import javax.servlet.Filter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@EnableConfigurationProperties(value={AuthSsoProperties.class})
public class AuthSsoClientConfiguration
implements WebMvcConfigurer,
ApplicationContextAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ApplicationContext applicationContext;
    private AuthSsoProperties authSsoProperties;

    public AuthSsoClientConfiguration(AuthSsoProperties authSsoProperties) {
        this.authSsoProperties = authSsoProperties;
    }

    @Bean
    public FilterRegistrationBean filterAuthenticationRegistration() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new OauthSsoFilter());
        registration.addInitParameter("ssoAuthCenter", this.authSsoProperties.getAuthCenterUrl());
        registration.addInitParameter("excludedPaths", String.join((CharSequence)",", this.authSsoProperties.getExcludePath()));
        registration.addInitParameter("ssoLogout", this.authSsoProperties.getAuthLogoutUrl());
        registration.addInitParameter("ssoType", this.authSsoProperties.getType());
        registration.addUrlPatterns(this.authSsoProperties.getPath());
        registration.setOrder(Integer.MIN_VALUE);
        return registration;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**").allowedOriginPatterns(new String[]{"*"}).allowCredentials(true).allowedMethods(new String[]{"GET", "POST", "DELETE", "PUT"}).maxAge(3600L);
    }

    private <T> T getBean(Class<T> clazz) {
        T bean = null;
        Collection beans = this.applicationContext.getBeansOfType(clazz).values();
        while (beans.iterator().hasNext() && (bean = (T)beans.iterator().next()) == null) {
        }
        return bean;
    }
}

