/*
 * Decompiled with CFR 0.152.
 */
package com.scsoft.scpt.sso.filter;

import com.alibaba.fastjson.JSONObject;
import com.scsoft.scpt.sso.bean.SsoUser;
import com.scsoft.scpt.sso.constants.SsoConstants;
import com.scsoft.scpt.sso.util.HttpUtil;
import com.scsoft.scpt.sso.util.SsoUtil;
import com.scsoft.scpt.sso.util.WebUtil;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.filter.OncePerRequestFilter;

public class OauthSsoFilter
extends OncePerRequestFilter {
    private static final AntPathMatcher antPathMatcher = new AntPathMatcher();
    private String authCenterUrL;
    private String logoutPath;
    private String excludedPaths;
    private String ssoType;
    private String baseLogout = "";

    public void initFilterBean() {
        this.authCenterUrL = this.getFilterConfig().getInitParameter("ssoAuthCenter");
        this.excludedPaths = this.getFilterConfig().getInitParameter("excludedPaths");
        this.ssoType = this.getFilterConfig().getInitParameter("ssoType");
        this.logger.info((Object)"OauthSsoFilter init.");
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String requestPath = request.getRequestURL().toString();
        String servletPath = this.constructServerPath(request);
        System.out.println("\u8bf7\u6c42\u8def\u5f84" + request.getRequestURI());
        HttpSession session = request.getSession();
        if (this.excludedPaths(request, servletPath)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        JSONObject jsonResult = null;
        String authssoKey = request.getParameter("ticket");
        if (StringUtils.isBlank((CharSequence)authssoKey)) {
            authssoKey = SsoUtil.readLoginSso(request);
        } else if (StringUtils.isBlank((CharSequence)SsoUtil.readLoginSso())) {
            SsoUtil.writeLoginSso(authssoKey, request, response);
        }
        String currentAuth = (String)session.getAttribute(SsoConstants.CURRENT_AUTH);
        String userName = (String)session.getAttribute("currentName");
        if (StringUtils.isNotBlank((CharSequence)userName) && authssoKey.equals(currentAuth)) {
            System.out.println("\u5df2\u7ecf\u5b58\u5728\u8ba4\u8bc1\u76f4\u63a5\u653e\u884c: " + requestPath);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        jsonResult = this.doAuthPost(this.ssoType, authssoKey);
        int code = (Integer)jsonResult.get((Object)"code");
        String data = jsonResult.get((Object)"data") + "";
        if (code != 200) {
            String loginUrl = this.constructRedirectUrl(data, requestPath);
            System.out.println("\u672a\u901a\u8fc7\u8ba4\u8bc1\uff0c\u72b6\u6001\u7801 >>>>>>" + code + "\u91cd\u5b9a\u5411\u81f3 >>>>>>" + loginUrl);
            if (this.ssoType.equals("1")) {
                this.returnMsg(code, "\u91cd\u5b9a\u5411\u5230\u767b\u5f55\u9875\u9762", loginUrl, response);
                return;
            }
            response.sendRedirect(loginUrl);
            return;
        }
        SsoUser ssoUser = (SsoUser)JSONObject.parseObject((String)data, SsoUser.class);
        session.setAttribute("currentUser", (Object)ssoUser);
        session.setAttribute("currentName", (Object)ssoUser.getUserName());
        session.setAttribute(SsoConstants.CURRENT_AUTH, (Object)authssoKey);
        request.setAttribute("currentName", (Object)ssoUser.getUserName());
        request.setAttribute(SsoConstants.CURRENT_AUTH, (Object)authssoKey);
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public JSONObject doAuthPost(String ssoType, String authsso) {
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("sinuo_auth_sso", authsso);
        params.put("ssoType", ssoType.trim());
        String result = (String)HttpUtil.doHttp(this.authCenterUrL, headerMap, params, "post", 2);
        JSONObject jsonResult = JSONObject.parseObject((String)result);
        return jsonResult;
    }

    public String constructRedirectUrl(String result, String requestPath) {
        String loginUrl = SsoUtil.constructRedirectUrl(result, "redirect_url", requestPath);
        return loginUrl;
    }

    public String constructServerPath(HttpServletRequest request) {
        String requri = request.getRequestURI();
        String contextPath = request.getContextPath();
        if (StringUtils.isNotBlank((CharSequence)contextPath)) {
            requri = requri.substring(contextPath.length());
        }
        return requri;
    }

    public boolean excludedPaths(HttpServletRequest request, String servletPath) {
        if (this.excludedPaths != null && this.excludedPaths.trim().length() > 0) {
            for (String excludedPath : this.excludedPaths.split(",")) {
                String uriPattern = excludedPath.trim();
                if (!antPathMatcher.match(uriPattern, servletPath)) continue;
                System.out.println("\u8bf7\u6c42\u5730\u5740\u653e\u884c: " + request.getRequestURL().toString());
                return true;
            }
        }
        return false;
    }

    private void returnMsg(int code, String msg, Object obj, HttpServletResponse response) {
        response.setHeader("Access-Control-Allow-Credentials", "true");
        response.setContentType("application/json;charset=UTF-8");
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setCharacterEncoding("UTF-8");
        JSONObject o = new JSONObject();
        o.put("code", (Object)code);
        o.put("msg", (Object)msg);
        o.put("data", obj);
        WebUtil.write(response, o);
    }
}

