/*
 * Decompiled with CFR 0.152.
 */
package com.scsoft.scpt.sso.util;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class CookieUtil {
    private static final int COOKIE_MAX_AGE = Integer.MAX_VALUE;
    private static final String COOKIE_PATH = "/";

    public static String getCookie(String name) {
        String value = "";
        try {
            if (StringUtils.isEmpty((CharSequence)name)) {
                System.err.println("\u4f20\u5165cookie\u4e2dname\u4e3a\u7a7a");
                return "";
            }
            ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            HttpServletRequest request = attributes.getRequest();
            Cookie[] cks = request.getCookies();
            if (null != cks) {
                for (Cookie cookie : cks) {
                    if (!name.equals(cookie.getName())) continue;
                    value = cookie.getValue();
                    System.out.println("\u83b7\u53d6\u5230cookie\u4e2dvalue:" + value);
                }
            } else {
                System.out.println("\u83b7\u53d6" + name + "\u503c\u4e3a\u7a7a");
            }
        }
        catch (Exception e) {
            System.err.println("\u83b7\u53d6cookie\u65f6\u62a5\u9519,\u62a5\u9519\u4fe1\u606f" + e.getMessage());
        }
        return value;
    }

    public static String getCookie(String name, HttpServletRequest request) {
        String value = "";
        try {
            if (StringUtils.isEmpty((CharSequence)name)) {
                System.err.println("\u4f20\u5165cookie\u4e2dname\u4e3a\u7a7a");
                return "";
            }
            Cookie[] cks = request.getCookies();
            if (null != cks) {
                for (Cookie cookie : cks) {
                    if (!name.equals(cookie.getName())) continue;
                    value = cookie.getValue();
                    System.out.println("\u83b7\u53d6\u5230cookie\u4e2dvalue:" + value);
                }
            } else {
                System.out.println("\u83b7\u53d6" + name + "\u503c\u4e3a\u7a7a");
            }
        }
        catch (Exception e) {
            System.err.println("\u83b7\u53d6cookie\u65f6\u62a5\u9519,\u62a5\u9519\u4fe1\u606f" + e.getMessage());
        }
        return value;
    }

    public static List<String> getCookieList(HttpServletRequest request) {
        Cookie[] cks = request.getCookies();
        ArrayList<String> cookies = new ArrayList<String>();
        for (Cookie cookie : cks) {
            cookies.add(cookie.getName());
        }
        return cookies;
    }

    public static void delCookie(String name, HttpServletRequest request, HttpServletResponse res) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            System.err.println("\u5220\u9664\u64cd\u4f5c\u4f20\u5165cookie\u4e2dname\u4e3a\u7a7a");
            return;
        }
        Cookie[] cks = request.getCookies();
        if (null != cks) {
            for (Cookie cookie : cks) {
                if (!name.equals(cookie.getName())) continue;
                Cookie c = new Cookie(name, null);
                c.setPath(COOKIE_PATH);
                c.setMaxAge(0);
                res.addCookie(c);
            }
        }
    }

    public static void delCookie(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            System.err.println("\u5220\u9664\u64cd\u4f5c\u4f20\u5165cookie\u4e2dname\u4e3a\u7a7a");
            return;
        }
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        Cookie[] cks = request.getCookies();
        if (null != cks) {
            for (Cookie cookie : cks) {
                if (!name.equals(cookie.getName())) continue;
                Cookie c = new Cookie(name, null);
                c.setPath(COOKIE_PATH);
                c.setMaxAge(0);
                HttpServletResponse res = attributes.getResponse();
                res.addCookie(c);
            }
        }
    }

    public static void addCookie(String name, String value, String domain, int maxAge) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath(COOKIE_PATH);
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        if (StringUtils.isNotBlank((CharSequence)domain)) {
            cookie.setDomain(domain);
        } else {
            cookie.setDomain(CookieUtil.getDomainName(request));
        }
        if (maxAge > 0) {
            cookie.setMaxAge(maxAge);
        }
        HttpServletResponse res = attributes.getResponse();
        res.addCookie(cookie);
    }

    public static void addCookie(String name, String value, String domain, int maxAge, HttpServletRequest request, HttpServletResponse res) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath(COOKIE_PATH);
        if (StringUtils.isNotBlank((CharSequence)domain)) {
            cookie.setDomain(domain);
        } else {
            cookie.setDomain(CookieUtil.getDomainName(request));
        }
        if (maxAge > 0) {
            cookie.setMaxAge(maxAge);
        }
        res.addCookie(cookie);
    }

    private static final String getDomainName(HttpServletRequest request) {
        String serverName = request.getRequestURL().toString();
        if (serverName == null || serverName.isEmpty()) {
            return "";
        }
        try {
            int portIndex;
            if (serverName.startsWith("http://")) {
                serverName = serverName.substring(7);
            } else if (serverName.startsWith("https://")) {
                serverName = serverName.substring(8);
            }
            int end = serverName.indexOf(COOKIE_PATH);
            if (end > 0) {
                serverName = serverName.substring(0, end);
            }
            if ((portIndex = serverName.indexOf(":")) > 0) {
                serverName = serverName.substring(0, portIndex);
            }
            if (CookieUtil.isIpAddress(serverName)) {
                return serverName;
            }
            if (!serverName.startsWith(".") && serverName.contains(".")) {
                return "." + serverName;
            }
            return serverName;
        }
        catch (Exception e) {
            return "";
        }
    }

    private static boolean isIpAddress(String domainName) {
        if (domainName == null || domainName.isEmpty()) {
            return false;
        }
        String[] parts = domainName.split("\\.");
        if (parts.length != 4) {
            return false;
        }
        for (String part : parts) {
            try {
                int num = Integer.parseInt(part);
                if (num >= 0 && num <= 255) continue;
                return false;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }
}

