/*
 * Decompiled with CFR 0.152.
 */
package com.scsoft.scpt.sso.util;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;

public class HttpUtil {
    private static PoolingHttpClientConnectionManager connMgr = new PoolingHttpClientConnectionManager();
    private static RequestConfig requestConfig;
    private static final int MAX_TIMEOUT = 7000;
    public static final int RTN_TYPE_1 = 1;
    public static final int RTN_TYPE_2 = 2;
    public static final int RTN_TYPE_3 = 3;
    public static final int RTN_TYPE_4 = 4;
    private static final String DEFAULT_BINARYBODY_KEYNAME = "file";

    public static String doGet(String apiUrl) {
        return (String)HttpUtil.doHttp(apiUrl, null, "get", 2);
    }

    public static String doPost(String apiUrl, Map<String, Object> params) {
        return (String)HttpUtil.doHttp(apiUrl, params, "post", 2);
    }

    public static String doPostJson(String apiUrl, String json) {
        return (String)HttpUtil.doHttp(apiUrl, json, "post", 2);
    }

    public static <T> T doHttp(String apiUrl, Object params, String method, int type) {
        return HttpUtil.doHttp(apiUrl, null, params, method, type);
    }

    public static <T> T doHttp(String apiUrl, Map<String, String> headerMap, Object params, String method, int type) {
        CloseableHttpClient httpClient = null;
        httpClient = HttpUtil.isSSL(apiUrl) ? HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)HttpUtil.createSSLConnSocketFactory()).setConnectionManager((HttpClientConnectionManager)connMgr).setDefaultRequestConfig(requestConfig).build() : HttpClients.createDefault();
        return HttpUtil.doHttp(httpClient, apiUrl, headerMap, params, method, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T doHttp(CloseableHttpClient httpClient, String apiUrl, Map<String, String> headerMap, Object params, String method, int type) {
        HttpPost httpPost = null;
        if (StringUtils.isNotBlank((CharSequence)method)) {
            if ("patch".equalsIgnoreCase(method)) {
                httpPost = new HttpPatch(apiUrl);
            } else if ("delete".equalsIgnoreCase(method)) {
                httpPost = new HttpDelete(apiUrl);
            } else if ("get".equalsIgnoreCase(method)) {
                httpPost = new HttpGet(apiUrl);
            } else if ("post".equalsIgnoreCase(method)) {
                httpPost = new HttpPost(apiUrl);
            }
        } else {
            httpPost = new HttpPost(apiUrl);
        }
        CloseableHttpResponse response = null;
        try {
            HttpEntity entity;
            Object pairList;
            if (headerMap != null && !headerMap.isEmpty()) {
                for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                    httpPost.addHeader(entry.getKey(), entry.getValue());
                }
            }
            if (HttpUtil.isSSL(apiUrl)) {
                httpPost.setConfig(requestConfig);
            }
            if (params != null) {
                if (httpPost instanceof HttpGet) {
                    StringBuffer param = new StringBuffer();
                    if (params instanceof Map) {
                        Map paramsConvert = (Map)params;
                        int i = 0;
                        for (String key : paramsConvert.keySet()) {
                            if (i == 0) {
                                param.append("?");
                            } else {
                                param.append("&");
                            }
                            param.append(key).append("=").append(paramsConvert.get(key));
                            ++i;
                        }
                    } else {
                        param.append("?" + params.toString());
                    }
                    apiUrl = apiUrl + param;
                    httpPost.setURI(URI.create(apiUrl));
                } else if (!(httpPost instanceof HttpDelete)) {
                    if (params instanceof Map) {
                        Map paramsConvert = (Map)params;
                        pairList = new ArrayList(paramsConvert.size());
                        for (Map.Entry entry : paramsConvert.entrySet()) {
                            BasicNameValuePair pair = new BasicNameValuePair((String)entry.getKey(), entry.getValue() == null ? "" : entry.getValue().toString());
                            pairList.add(pair);
                        }
                        ((HttpEntityEnclosingRequestBase)httpPost).setEntity((HttpEntity)new UrlEncodedFormEntity((Iterable)pairList, Charset.forName("UTF-8")));
                    } else {
                        StringEntity stringEntity = new StringEntity(params.toString(), "UTF-8");
                        stringEntity.setContentEncoding("UTF-8");
                        stringEntity.setContentType("application/json");
                        ((HttpEntityEnclosingRequestBase)httpPost).setEntity((HttpEntity)stringEntity);
                    }
                }
            }
            if ((entity = (response = httpClient.execute((HttpUriRequest)httpPost)).getEntity()) != null) {
                if (type == 1) {
                    pairList = entity.getContent();
                    return (T)pairList;
                }
                if (2 == type) {
                    pairList = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                    return (T)pairList;
                }
                if (3 == type || 4 == type) {
                    HashMap<String, String> rtnMap = new HashMap<String, String>();
                    rtnMap.put("result", EntityUtils.toString((HttpEntity)entity, (String)"UTF-8"));
                    rtnMap.put("statusCode", response.getStatusLine().getStatusCode() + "");
                    if (4 == type) {
                        rtnMap.put("cookie", HttpUtil.getCookie((HttpResponse)response));
                    }
                    HashMap<String, String> e = rtnMap;
                    return (T)e;
                }
                String string = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                return (T)string;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (response != null && type != 1) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private static String getCookie(HttpResponse httpResponse) {
        String[] cookies;
        HashMap<String, String> cookieMap = new HashMap<String, String>(64);
        Header[] headers = httpResponse.getHeaders("Set-Cookie");
        if (headers == null || headers.length == 0) {
            return null;
        }
        String cookie = "";
        for (int i = 0; i < headers.length; ++i) {
            cookie = cookie + headers[i].getValue();
            if (i == headers.length - 1) continue;
            cookie = cookie + ";";
        }
        for (String c : cookies = cookie.split(";")) {
            if (cookieMap.containsKey((c = c.trim()).split("=")[0])) {
                cookieMap.remove(c.split("=")[0]);
            }
            cookieMap.put(c.split("=")[0], c.split("=").length == 1 ? "" : (c.split("=").length == 2 ? c.split("=")[1] : c.split("=", 2)[1]));
        }
        String cookiesTmp = "";
        for (String key : cookieMap.keySet()) {
            cookiesTmp = cookiesTmp + key + "=" + (String)cookieMap.get(key) + ";";
        }
        return cookiesTmp.substring(0, cookiesTmp.length() - 2);
    }

    public static SSLConnectionSocketFactory createSSLConnSocketFactory() {
        SSLConnectionSocketFactory sslsf = null;
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            sslsf = new SSLConnectionSocketFactory(sslContext, new HostnameVerifier(){

                @Override
                public boolean verify(String arg0, SSLSession arg1) {
                    return true;
                }
            });
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        return sslsf;
    }

    public static PoolingHttpClientConnectionManager getConnMgr() {
        return connMgr;
    }

    public static RequestConfig getRequestConfig() {
        return requestConfig;
    }

    private static boolean isSSL(String apiUrl) {
        return apiUrl.indexOf("https") != -1;
    }

    static {
        connMgr.setMaxTotal(100);
        connMgr.setDefaultMaxPerRoute(connMgr.getMaxTotal());
        connMgr.setValidateAfterInactivity(1);
        RequestConfig.Builder configBuilder = RequestConfig.custom();
        configBuilder.setConnectTimeout(7000);
        configBuilder.setSocketTimeout(7000);
        configBuilder.setConnectionRequestTimeout(7000);
        requestConfig = configBuilder.build();
    }
}

