/*
 * Decompiled with CFR 0.152.
 */
package com.scsoft.scpt.sso.util;

import com.scsoft.scpt.sso.util.CookieUtil;
import com.scsoft.scpt.sso.util.UUIDUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SsoUtil {
    private static Logger logger = LoggerFactory.getLogger(SsoUtil.class);
    private static final String COOKIE_PATH = "/";
    public static final int COOKIE_MAX_AGE = 86400;
    public static final String COOKIE_NAME = "sinuo_auth_sso";
    public static final String TICKET = "ticket";
    public static final String REDIRECT_URL = "redirect_url";

    public static String readLoginSso() {
        String sinuoSso = CookieUtil.getCookie(COOKIE_NAME);
        return sinuoSso;
    }

    public static String readLoginSso(HttpServletRequest request) {
        String sinuoSso = CookieUtil.getCookie(COOKIE_NAME, request);
        return sinuoSso;
    }

    public static String writeLoginSso() {
        String sinuoSso = UUIDUtil.getUid("sinuo-");
        CookieUtil.addCookie(COOKIE_NAME, sinuoSso, null, 86400);
        return sinuoSso;
    }

    public static String writeLoginSso(String sinuoSso) {
        CookieUtil.addCookie(COOKIE_NAME, sinuoSso, null, 86400);
        return sinuoSso;
    }

    public static String writeLoginSso(String sinuoSso, HttpServletRequest request, HttpServletResponse response) {
        CookieUtil.addCookie(COOKIE_NAME, sinuoSso, null, 86400, request, response);
        return sinuoSso;
    }

    public static void deleteLoginSso() {
        CookieUtil.delCookie(COOKIE_NAME);
    }

    public static String constructRedirectUrl(String authCenterUrL, String serviceParameterName, String serviceUrl) {
        try {
            return authCenterUrL + (authCenterUrL.indexOf("?") != -1 ? "&" : "?") + serviceParameterName + "=" + URLEncoder.encode(serviceUrl, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static String takeToken(HttpServletRequest request) {
        String acparam_token;
        String access_token = request.getHeader("Authorization");
        if ((access_token == null || access_token.trim().isEmpty()) && StringUtils.isNotBlank((CharSequence)(acparam_token = request.getParameter("sinuo-token")))) {
            access_token = acparam_token;
        }
        return access_token;
    }

    public static String takeAuthSso(HttpServletRequest request) {
        String access_token = request.getHeader(COOKIE_NAME);
        return access_token;
    }

    public static void logout(HttpServletRequest request) {
        SsoUtil.deleteLoginSso();
        List<String> cookies = CookieUtil.getCookieList(request);
        for (String cookieName : cookies) {
            CookieUtil.delCookie(cookieName);
        }
    }
}

