/*
 * Decompiled with CFR 0.152.
 */
package com.scsoft.scpt.sso.util;

import java.math.BigInteger;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public class UUIDUtil {
    private static final String[] chars = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};

    public static String randomUUID8() {
        StringBuffer shortBuffer = new StringBuffer();
        String uuid = UUID.randomUUID().toString().replace("-", "");
        for (int i = 0; i < 8; ++i) {
            String str = uuid.substring(i * 4, i * 4 + 4);
            int x = Integer.parseInt(str, 16);
            shortBuffer.append(chars[x % 62]);
        }
        return shortBuffer.toString();
    }

    public static String randomUUID32() {
        String uuid = UUID.randomUUID().toString().replace("-", "");
        return uuid;
    }

    public static String getUid() {
        return UUIDUtil.getUUIDStr();
    }

    public static String getUid(String prefix) {
        return prefix + UUIDUtil.getUUIDStr();
    }

    public static String getUid(String prefix, int Length) {
        return prefix + UUIDUtil.getUUIDByLength(Length);
    }

    public static String getShortUid() {
        StringBuilder shortBuffer = new StringBuilder();
        String uuid = UUID.randomUUID().toString().replace("-", "");
        for (int i = 0; i < 8; ++i) {
            String str = uuid.substring(i * 4, i * 4 + 4);
            int x = Integer.parseInt(str, 16);
            shortBuffer.append(chars[x % 62]);
        }
        return shortBuffer.toString();
    }

    public static String getUUIDByLength(int length) {
        if (length < 1) {
            return null;
        }
        StringBuffer sBuffer = new StringBuffer();
        for (int i = 0; i <= length / 22; ++i) {
            sBuffer.append(UUIDUtil.getUid());
        }
        return sBuffer.toString().substring(0, length);
    }

    private static BigInteger unsigned2BigInt(long value) {
        if (value >= 0L) {
            return BigInteger.valueOf(value);
        }
        long lowValue = value & Long.MAX_VALUE;
        return BigInteger.valueOf(lowValue).add(BigInteger.valueOf(Long.MAX_VALUE)).add(BigInteger.valueOf(1L));
    }

    private static String getUUIDStr() {
        BigInteger[] s;
        UUID uuid = UUID.randomUUID();
        BigInteger pt1 = UUIDUtil.unsigned2BigInt(uuid.getMostSignificantBits());
        BigInteger pt2 = UUIDUtil.unsigned2BigInt(uuid.getLeastSignificantBits());
        StringBuilder sb = new StringBuilder();
        while (pt1.longValue() != 0L) {
            s = pt1.divideAndRemainder(BigInteger.valueOf(chars.length));
            sb.append(chars[s[1].intValue()]);
            pt1 = s[0];
        }
        sb.append(StringUtils.repeat((String)chars[0], (int)(11 - sb.length())));
        while (pt2.longValue() != 0L) {
            s = pt2.divideAndRemainder(BigInteger.valueOf(chars.length));
            sb.append(chars[s[1].intValue()]);
            pt2 = s[0];
        }
        sb.append(StringUtils.repeat((String)chars[0], (int)(22 - sb.length())));
        return StringUtils.reverse((String)sb.toString());
    }
}

