/*
 * Decompiled with CFR 0.152.
 */
package com.scsoft.scpt.sso.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class WebUtil {
    private static final Logger log = LoggerFactory.getLogger(WebUtil.class);

    public static String getContextPath(HttpServletRequest request) {
        return request.getSession().getServletContext().getContextPath();
    }

    public static String getRemoteAddr(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (StringUtils.isBlank((CharSequence)ip) || StringUtils.equalsIgnoreCase((CharSequence)ip, (CharSequence)"unknown")) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (StringUtils.isBlank((CharSequence)ip) || StringUtils.equalsIgnoreCase((CharSequence)ip, (CharSequence)"unknown")) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (StringUtils.isBlank((CharSequence)ip) || StringUtils.equalsIgnoreCase((CharSequence)ip, (CharSequence)"unknown")) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (StringUtils.isBlank((CharSequence)ip) || StringUtils.equalsIgnoreCase((CharSequence)ip, (CharSequence)"unknown")) {
            ip = request.getHeader("X-Real-IP");
        }
        if (StringUtils.isBlank((CharSequence)ip) || StringUtils.equalsIgnoreCase((CharSequence)ip, (CharSequence)"unknown")) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (StringUtils.isBlank((CharSequence)ip) || StringUtils.equalsIgnoreCase((CharSequence)ip, (CharSequence)"unknown")) {
            ip = request.getRemoteAddr();
        }
        if (StringUtils.isNotBlank((CharSequence)ip) && StringUtils.indexOf((CharSequence)ip, (CharSequence)",") > 0) {
            String[] ipArray = StringUtils.split((String)ip, (String)",");
            ip = ipArray[0];
        }
        return ip;
    }

    public static String getLocalAddr() {
        InetAddress addr = null;
        try {
            addr = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return addr.getHostAddress();
    }

    public static String encodingHelp(String s) throws Exception {
        return new String(s.getBytes("ISO-8859-1"), "UTF-8");
    }

    public static String ajaxDecode(String s) throws Exception {
        return URLDecoder.decode(s, "UTF8");
    }

    public static void alertMsg(HttpServletResponse response, String msg) throws Exception {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/html");
        StringBuilder sb = new StringBuilder();
        sb.append("<script type='text/javascript'>");
        sb.append("alert(\"" + msg + "\");");
        sb.append("</script>");
        PrintWriter out = response.getWriter();
        out.print(sb.toString());
        out.close();
    }

    public static HttpServletRequest getRequest() {
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
    }

    public static boolean isAjaxRequest(HttpServletRequest request) {
        String accept = request.getHeader("accept");
        if (accept != null && accept.indexOf("application/json") != -1) {
            return true;
        }
        String xRequestedWith = request.getHeader("X-Requested-With");
        if (xRequestedWith != null && xRequestedWith.indexOf("XMLHttpRequest") != -1) {
            return true;
        }
        String uri = request.getRequestURI();
        if (WebUtil.inStringIgnoreCase(uri, ".json", ".xml")) {
            return true;
        }
        String ajax = request.getParameter("__ajax");
        return WebUtil.inStringIgnoreCase(ajax, "json", "xml");
    }

    public static void write(HttpServletResponse response, Object o) {
        try {
            response.setContentType("text/html;charset=utf-8");
            response.setCharacterEncoding("utf-8");
            PrintWriter out = response.getWriter();
            out.println(o.toString());
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static HttpServletResponse getResponse() {
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
    }

    public static ServletRequestAttributes getRequestAttributes() {
        RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
        return (ServletRequestAttributes)attributes;
    }

    public static String getParameter(String name) {
        return WebUtil.getRequest().getParameter(name);
    }

    public static String getParameter(String name, String defaultValue) {
        String value = WebUtil.getRequest().getParameter(name);
        if (null == value) {
            return defaultValue;
        }
        if (value instanceof String) {
            return value;
        }
        return value.toString();
    }

    public static String renderString(HttpServletResponse response, String string) {
        try {
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            PrintWriter out = response.getWriter();
            out.print(string);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getUrl() {
        HttpServletRequest request = WebUtil.getRequest();
        return WebUtil.getDomain(request);
    }

    public static String getDomain(HttpServletRequest request) {
        StringBuffer url = request.getRequestURL();
        String contextPath = request.getServletContext().getContextPath();
        return url.delete(url.length() - request.getRequestURI().length(), url.length()).append(contextPath).toString();
    }

    public static boolean inStringIgnoreCase(String str, String ... strs) {
        if (str != null && strs != null) {
            for (String s : strs) {
                if (!str.equalsIgnoreCase(WebUtil.trim(s))) continue;
                return true;
            }
        }
        return false;
    }

    public static String trim(String str) {
        return str == null ? "" : str.trim();
    }
}

